from typing import Dict, Any, List

from ..action_space import FormalizationAction, ActionType
from ..symbol_manager import SymbolManager

from utils.logger import Logger
from llm.llm_wrapper import LLMWrapper
from llm.message import (
    Message,
    MessageContent,
    ROLE_SYSTEM,
    ROLE_USER,
    ROLE_ASSISTANT,
    TYPE_SETTING,
    TYPE_CONTEXT,
    TYPE_CONTENT,
)

class FallbackAction(FormalizationAction):

    def __init__(self, logger: Logger, llm: LLMWrapper, symbol_manager: SymbolManager):
        super().__init__(logger, llm, symbol_manager)

    def get_type(self):
        return ActionType.FALLBACK

    def should_apply(self, text, context=None):
        if not context:
            return False
        history = context.get('applied_history', None)
        if not history or len(history) < 2:
            return False
        return True

    def apply(self, text, context=None):
        if not context:
            return {
                "success": False,
                "message": "No previous state to fall back",
            }
        history = context.get("applied_history", None)
        if not history:
            return {
                "success": False,
                "message": "No previous state to fall back",
            }
        
        try:
            last_last_action = history[-2]
            transformed_text = last_last_action.get('query', '')
            response = last_last_action.get('response', '')
        except IndexError:
            return {
                "success": False,
                "message": "Error accessing history",
            }
        self.logger.info(f"Falling back from '{text}' to '{transformed_text}'")

        return {
            "success": True,
            "transformed_info": None,
            "transformed_text": transformed_text,
            "response": response,
        }
